% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct.R
\name{ct_spec_example}
\alias{ct_spec_example}
\title{Find the path to an example controlled terminology file}
\usage{
ct_spec_example(example)
}
\arguments{
\item{example}{A string with either the basename, file name, or relative path
to a controlled terminology file bundled with \code{{stdm.oak}}, see examples.}
}
\value{
The local path to an example file if \code{example} is supplied, or a
character vector of example file names.
}
\description{
\code{\link[=ct_spec_example]{ct_spec_example()}} resolves the local path to an example controlled
terminology file.
}
\examples{
# Get the local path to controlled terminology example file 01
# Using the basename only:
ct_spec_example("ct-01-cm")

# Using the file name:
ct_spec_example("ct-01-cm.csv")

# Using the relative path:
ct_spec_example("ct/ct-01-cm.csv")

# If no example is provided it returns a vector of possible choices.
ct_spec_example()

}
