% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fixindependent}
\alias{fixindependent}
\title{Fix Independent Arguments of a Tape}
\usage{
fixindependent(pfun, x, isfixed)
}
\arguments{
\item{pfun}{An \code{Rcpp_ADFun} object.}

\item{x}{A numerical vector specifying the value of all independent arguments of \code{pfun}. Some of these will be fixed according to \code{isfixed}, the remainder will remain as independent arguments.}

\item{isfixed}{A boolean vector same length as \code{x}. \code{TRUE} values are fixed at the value of \code{x}, \code{FALSE} values are left as independent arguments.}
}
\value{
An \code{Rcpp_ADFun} object.
}
\description{
Retapes an existing \code{CppAD} tape but with some of original independent arguments fixed to specified values.
For creating this tape, the values of \code{pfun$dyntape} are used.
}
\seealso{
Other tape builders: 
\code{\link{avgrange}()},
\code{\link{fixdynamic}()},
\code{\link{keeprange}()},
\code{\link{tape_Hessian}()},
\code{\link{tape_Jacobian}()},
\code{\link{tape_bdryw}()},
\code{\link{tape_gradoffset}()},
\code{\link{tape_logJacdet}()},
\code{\link{tape_smd}()},
\code{\link{tape_swap}()},
\code{\link{tape_uld}()}
}
\concept{tape builders}
