% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scholar.r
\name{author_position}
\alias{author_position}
\title{Get author order.}
\usage{
author_position(authorlist, author)
}
\arguments{
\item{authorlist}{list of publication authors}

\item{author}{author's name to look for}
}
\value{
dataframe with author's position and normalized position (a normalized index, with 0 corresponding, 1 to last and 0.5 to the middle. Note that single authorship will be considered as last, i.e., 1).
}
\description{
Get author rank in authors list.
}
\examples{
\dontrun{
library(scholar)

id <- "DO5oG40AAAAJ"

authorlist <- scholar::get_publications(id)$author
author <- scholar::get_profile(id)$name

author_position(authorlist, author)
}

}
\author{
Dominique Makowski
}
