% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_mean.R
\name{scf_mean}
\alias{scf_mean}
\title{Estimate Mean in Multiply-Imputed SCF Data}
\usage{
scf_mean(scf, var, by = NULL, verbose = FALSE)
}
\arguments{
\item{scf}{A scf_mi_survey object created with \code{\link[=scf_load]{scf_load()}}. Must contain five replicate-weighted implicates.}

\item{var}{A one-sided formula identifying the continuous variable to summarize (e.g., ~networth).}

\item{by}{Optional one-sided formula specifying a discrete grouping variable for stratified means.}

\item{verbose}{Logical. If TRUE, include implicate-level results in print output. Default is FALSE.}
}
\value{
A list of class "scf_mean" with:
\describe{
\item{results}{Pooled estimates with standard errors and range across implicates. One row per group, or one row total.}
\item{imps}{A named list of implicate-level estimates.}
\item{aux}{Variable and group metadata.}
}
}
\description{
Returns the population-level estimate of a continuous variable's weighted
mean across the Survey's five implicates. Use this operation to derive an
estimate of a population's 'typical' or 'average' score on a continuous
variable.
}
\section{Details}{

The mean is a measure of central tendency that represents the arithmetic average of a distribution.
It is most appropriate when the distribution is symmetric and not heavily skewed.
Unlike the median, the mean is sensitive to extreme values, which may distort interpretation in the presence of outliers.
Use this function to describe the “typical” value of a continuous variable in the population or within subgroups.
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td <- tempfile("mean_")
dir.create(td)

src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Estimate means
scf_mean(scf2022, ~networth)
scf_mean(scf2022, ~networth, by = ~edcl)

# Do not implement these lines in real analysis: Cleanup for package check
unlink(td, recursive = TRUE, force = TRUE)


}
\seealso{
\code{\link[=scf_median]{scf_median()}}, \code{\link[=scf_percentile]{scf_percentile()}}, \code{\link[=scf_xtab]{scf_xtab()}}, \code{\link[=scf_plot_dist]{scf_plot_dist()}}
}
