% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetSeuratGroups}
\alias{GetSeuratGroups}
\title{GetSeuratGroups}
\usage{
GetSeuratGroups(q)
}
\arguments{
\item{q}{The S4 Seurat object (for example, returned by a call to readRDS('file.rds') where the rds file was written by Seurat).}
}
\value{
The numeric integer vector with as many components as cells.
}
\description{
Returns a numeric vector of integers with the numeric identifier of the group to which each cell in a Seurat object belongs to, if the cells come from 
different groups/samples. These numeric identifiers go from 1 to the number of groups; names of original factors are not kept.
}
\details{
If q is the Seurat object, this function assumes that\cr
 \cr
q@meta.data$orig.ident\cr
 \cr
is the integer vector with this information. We don't know if this is assumed by all software which uses Seurat (probably, not)
so this function is likely NOT to work in most cases and therefore is provided just as a convenience that can generate the parameter gr
for the BuildAbundanceMatrix. But if the data you have got does not follow these conventions, please don't blame us...
}
\examples{
# Sorry, we cannot provide an example here, since it would need the load of the Seurat package.
# Please, see the vignette for examples
}
