% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_parameters.R
\name{ExtractParameters}
\alias{ExtractParameters}
\title{Get Simulation Parameters}
\usage{
ExtractParameters(sim_object, steps = NULL)
}
\arguments{
\item{sim_object}{simulation object created with \code{\link{CreateSimulationObject}}}

\item{steps}{which parameters to extract from the \code{SpatSimObj}}
}
\value{
a list of S3 clas \code{SimParams} containing parameters stored in the \code{sim_object}
}
\description{
Get Simulation Parameters
}
\details{
This function will return any paramters that are stored in the simulation object. If no simulation steps
have been run, then this will return the default parameters. The defaults are over written if new parameters
are provided at each step.
}
\examples{

#create simulation object
sim_obj = CreateSimulationObject()
#extract default paramters for the Tissue simulation step
defs = ExtractParameters(sim_obj, "Tissue")
}
