% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sazed.R
\name{zed}
\alias{zed}
\title{Compute the ZED component of the SAZED ensemble}
\usage{
zed(y, preprocess = T)
}
\arguments{
\item{y}{The input time series.}

\item{preprocess}{If true, y is detrended and z-normalized before
computation.}
}
\value{
The ZED season length estimate of y.
}
\description{
\code{zed} computes the zero density of its argument, and then derives the
season length from it.
}
\examples{
season_length <- 26
y <- sin(1:400*2*pi/season_length)
zed(y)
zed(y, preprocess = FALSE)
}
