% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-matrix-arithmetic.r
\name{matmult}
\alias{matmult}
\alias{matrixprod_dn}
\alias{matrixprod_nd}
\alias{matrixprod_dd}
\alias{\%*\%,dual,numericOrArray-method}
\alias{\%*\%,numericOrArray,dual-method}
\alias{\%*\%,dual,dual-method}
\alias{crossprod,dual,dual-method}
\alias{crossprod,dual,numericOrArray-method}
\alias{crossprod,numericOrArray,dual-method}
\alias{crossprod,dual,missing-method}
\alias{tcrossprod,dual,dual-method}
\alias{tcrossprod,dual,numericOrArray-method}
\alias{tcrossprod,numericOrArray,dual-method}
\alias{tcrossprod,dual,missing-method}
\title{Matrix Arithmetic}
\usage{
matrixprod_dn(x, y)

matrixprod_nd(x, y)

matrixprod_dd(x, y)

\S4method{\%*\%}{dual,numericOrArray}(x, y)

\S4method{\%*\%}{numericOrArray,dual}(x, y)

\S4method{\%*\%}{dual,dual}(x, y)

\S4method{crossprod}{dual,dual}(x, y)

\S4method{crossprod}{dual,numericOrArray}(x, y)

\S4method{crossprod}{numericOrArray,dual}(x, y)

\S4method{crossprod}{dual,missing}(x, y)

\S4method{tcrossprod}{dual,dual}(x, y)

\S4method{tcrossprod}{dual,numericOrArray}(x, y)

\S4method{tcrossprod}{numericOrArray,dual}(x, y)

\S4method{tcrossprod}{dual,missing}(x, y)
}
\arguments{
\item{x, y}{Dual or numeric matrices or vectors}
}
\value{
A dual object.
}
\description{
Methods and functions for dual matrix arithmetic
}
\details{
All methods are the analog of the corresponding methods for matrices.
The functions `matrixprod_dd`, `matrixprod_nd` and `matrixprod_dn` are for multiplication
of two dual objects, of a numeric and a dual object, or of a dual and a numeric object,
respectively. You may use these functions to save the method dispatching time.
}
\examples{
x <- dual( matrix(c(0,1,3,1), 2, 2) )
y <- x \%*\% c(2,-2)
d(y, "x1.1")
}
