% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-apply.r
\name{apply,dual-method}
\alias{apply,dual-method}
\title{Apply functions over array margins of dual objects}
\usage{
\S4method{apply}{dual}(X, MARGIN, FUN, ..., simplify = TRUE)
}
\arguments{
\item{X}{a dual object (with array or matrix shape)}

\item{MARGIN}{a vector giving the subscript which the function will be applied over}

\item{FUN}{the function to be applied}

\item{...}{extra arguments for `FUN`}

\item{simplify}{a logical indicating whether the results should be simplified}
}
\value{
The returned value depends on the values returned by `FUN`, similarly to `base::apply`
}
\description{
This method generalizes `base::apply` to dual objects.
}
\examples{
A <- matrix( c(1,2,3,4), 2, 2)
x <- dual(A)
cs <- apply(x, 2, sum)
cs
d(cs)
# prefered method for summing over the columns
colSums(x) 
}
\seealso{
\code{\link{apply}}
}
