% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{computeBootObj}
\alias{computeBootObj}
\title{Computes the bootObj for sequential sampling procedures regarding nPlan, beta, the implied target}
\usage{
computeBootObj(
  values,
  beta = NULL,
  nPlan = NULL,
  nBoot = 1000L,
  alpha = NULL,
  objType = c("nPlan", "nMean", "beta", "betaFromEValues", "logImpliedTarget",
    "expectedStopTime")
)
}
\arguments{
\item{values}{numeric vector. If objType equals "nPlan" or "beta" then values should be stopping times,
if objType equals "logImpliedTarget" then values should be eValues.}

\item{beta}{numeric in (0, 1) that specifies the tolerable type II error control necessary to calculate both "n"
and "phiS". Note that 1-beta defines the power.}

\item{nPlan}{integer > 0 representing the number of planned samples (for the first group).}

\item{nBoot}{integer > 0 representing the number of bootstrap samples to assess the accuracy of
approximation of the power, the planned sample size(s) of the safe test under continuous monitoring.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{objType}{character string either "nPlan", "nMean", "beta", "betaFromEValues", "expectedStopTime" or "logImpliedTarget".}
}
\value{
bootObj
}
\description{
Computes the bootObj for sequential sampling procedures regarding nPlan, beta, the implied target
}
\examples{
computeBootObj(1:100, objType="nPlan", beta=0.3)
}
