% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runExample.r
\name{runExample}
\alias{runExample}
\title{Run Shiny Application}
\usage{
runExample(port=NULL,launch.browser=TRUE,
 host=getOption('shiny.host','127.0.0.1'),display.mode='auto')
}
\arguments{
\item{port}{The TCP port that the application should listen on. If the
\code{port} is not specified, and the \code{shiny.port} option is set (with
\code{options(shiny.port = XX)}), then that port will be used. Otherwise,
use a random port.}

\item{launch.browser}{If true, the system's default web browser will be
launched automatically after the app is started. Defaults to true in
interactive sessions only. This value of this parameter can also be a
function to call with the application's URL.}

\item{host}{The IPv4 address that the application should listen on. Defaults
to the \code{shiny.host} option, if set, or \code{"127.0.0.1"} if not. See
Details.}

\item{display.mode}{The mode in which to display the application. If set to
the value \code{"showcase"}, shows application code and metadata from a
\code{DESCRIPTION} file in the application directory alongside the
application. If set to \code{"normal"}, displays the application normally.
Defaults to \code{"auto"}, which displays the application in the mode given
in its \code{DESCRIPTION} file, if any.}
}
\description{
Runs a shiny application which draws from the given distributions, then
illustrates the fidelity of the density, CDF, and quantile functions.
}
\details{
Launches shiny applications, and optionally, your system's web browser.
Draws are taken from the random variable, and d-d, q-q, and p-p plots
are available.
}
\examples{
\dontrun{
runExample(launch.browser=TRUE)
}
}
\references{
Attali, D. "Supplementing your R package with a shiny app."
\url{https://deanattali.com/2015/04/21/r-package-shiny-app/}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
