% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lenplot.R
\name{lenplot}
\alias{lenplot}
\title{Generate the sRNA length distribution plot}
\usage{
lenplot(file_dataframe, width = 0.6, size = 12)
}
\arguments{
\item{file_dataframe}{A dataframe. The output result after running "srnapredata".}

\item{width}{A numeric. The width of the output bar plot, and default is 0.6.}

\item{size}{A numeric. The size of text in the outpot plot, and default is 12.}
}
\value{
The sRNA length distribution plot
}
\description{
Generate the sRNA length distribution plot
}
\examples{
##F1
F1_sRNA <- srnapredata(srnaseq_dataframe = F1_sRNA_seq, group = "F1")
##P1
P1_sRNA <- srnapredata(srnaseq_dataframe = P1_sRNA_seq, group = "P1")
##P2
P2_sRNA <- srnapredata(srnaseq_dataframe = P2_sRNA_seq, group = "P2")
##integrate all sRNA data from P1, P2, and F1
sRNA_data <- rbind(F1_sRNA,P1_sRNA,P2_sRNA)
##plot
lenplot(file_dataframe = sRNA_data)
}
