#' Synthetic Control Chart Time Series Data Set
#'
#' This dataset contains 600 examples of control charts synthetically generated by the process in Alcock and Manolopoulos (1999) and obtained from the UCI Machine Learning Repository \url{http://archive.ics.uci.edu/ml/datasets/Synthetic+Control+Chart+Time+Series}.
#'
#' There are six different classes of control charts:
#' \enumerate{
#'      \item Normal (Rows 1-100)
#'      \item Cyclic (Rows 101-200)
#'      \item Increasing trend (Rows 201-300)
#'      \item Decreasing trend (Rows 301-400)
#'      \item Upward shift (Rows 401-500)
#'      \item Downward shift (Rows 501-600)
#'      }
#'
#' @name synthetic_control
#' @docType data
#' @format A matrix with 600 rows (series) and 60 columns (timepoints)
#'
#' @references Alcock R.J. and Manolopoulos Y. Time-Series Similarity Queries Employing a Feature-Based Approach. 7th Hellenic Conference on Informatics. August 27-29. Ioannina, Greece 1999.
#' @keywords data
NULL
