% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA_DCt.R
\name{ANOVA_DCt}
\alias{ANOVA_DCt}
\title{Delta Ct ANOVA analysis with optional model specification}
\usage{
ANOVA_DCt(
  x,
  numOfFactors,
  numberOfrefGenes,
  block = NULL,
  alpha = 0.05,
  p.adj = "none",
  analyseAllTarget = TRUE,
  model = NULL,
  set_missing_target_Ct_to_40 = FALSE
)
}
\arguments{
\item{x}{The input data frame containing experimental design columns, target gene
E/Ct column pairs, and reference gene E/Ct column pairs. Reference gene
columns must be located at the end of the data frame. See "Input data 
structure" in vignettes for details about data structure.}

\item{numOfFactors}{Integer. Number of experimental factor columns 
(excluding \code{rep} and optional \code{block}).}

\item{numberOfrefGenes}{Integer. Number of reference genes. Each reference gene
must be represented by two columns (E and Ct).}

\item{block}{Character. Block column name or \code{NULL}. When a qPCR experiment 
is done in multiple qPCR plates, variation resulting from the plates may 
interfere with the actual amount of gene expression. One solution is to 
conduct each plate as a randomized block so that at least one replicate of 
each treatment and control is present on a plate. Block effect is usually 
considered as random and its interaction with any main effect is not considered.
Note: This parameter is ignored if \code{model} is provided.}

\item{alpha}{Statistical level for comparisons (default: 0.05).}

\item{p.adj}{Method for p-value adjustment. See \code{\link[stats]{p.adjust}}.}

\item{analyseAllTarget}{Logical or character. If \code{TRUE} (default), all 
detected target genes are analysed. Alternatively, a character vector 
specifying the names (names of their Efficiency columns) of target genes 
to be analysed.}

\item{model}{Optional model formula. If provided, this overrides the automatic formula (CRD or RCBD 
based on \code{block} and \code{numOfFactors}). The formula uses 
\code{wDCt} as the response variable. 
For mixed models, random effects can be defined using \code{lmer} syntax 
(e.g., \code{"wDCt ~ Treatment + (1|Block)"}). When using \code{model}, 
the \code{block} and \code{numOfFactors} arguments are ignored for model 
specification, but still used for data structure identification.}

\item{set_missing_target_Ct_to_40}{If \code{TRUE}, missing target gene Ct values become 40; if \code{FALSE} (default), they become NA.}
}
\value{
An object containing expression tables, lm/lmer models, ANOVA tables, 
residuals, and raw data for each gene:
\describe{
\item{\code{relativeExpression}}{dCt expression table for all treatment 
  combinations along with per-gene statistical grouping}
\item{\code{perGene}}{Nested list containing detailed results for each target gene:
  \itemize{
  \item \code{ANOVA_table}: Full factorial ANOVA table
  \item \code{lm}: lm/lmer model for factorial design
  \item \code{Final_data}: Processed data with wDCt values
  \item \code{resid(object$perGene$gene_name$lm)}: Residuals
  }}
}
}
\description{
Performs Delta Ct (dCt) analysis of the data from a 1-, 2-, or 3-factor experiment 
with support for both fixed effects and mixed effects models. Per-gene statistical 
grouping is performed for all treatment combinations.
}
\details{
The function performs ANOVA analysis on weighted delta Ct (wDCt) values and returns 
variance components along with an expression table containing:
\itemize{
\item \code{gene}: Name of target genes
\item Factor columns: Experimental design factors
\item \code{dCt}: Mean weighted delta Ct for each treatment combination
\item \code{RE}: Relative expression = 2^-dCt
\item \code{log2FC}: log2 of relative expression
\item \code{LCL}: 95\% lower confidence level
\item \code{UCL}: 95\% upper confidence level
\item \code{se}: Standard error of the mean calculated from wDCt values
\item \code{Lower.se.RE}: Lower limit error bar for RE (2^(log2(RE) - se))
\item \code{Upper.se.RE}: Upper limit error bar for RE (2^(log2(RE) + se))
\item \code{Lower.se.log2FC}: Lower limit error bar for log2 RE
\item \code{Upper.se.log2FC}: Upper limit error bar for log2 RE
\item \code{sig}: Per-gene significance grouping letters
}
}
\examples{
# Default usage with fixed effects
result <- ANOVA_DCt(data_2factorBlock3ref, numOfFactors = 2, numberOfrefGenes = 3, 
                    block = "block")

# Mixed model with random block effect
result_mixed <- ANOVA_DCt(data_2factorBlock3ref, numOfFactors = 2, numberOfrefGenes = 3,
                          block = "block")

# Custom mixed model formula with nested random effects
result_custom <- ANOVA_DCt(data_repeated_measure_2, numOfFactors = 2, numberOfrefGenes = 1,
                            block = NULL,
                            model = wDCt ~ treatment * time + (1 | id))


}
