% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_rtl.R
\name{str_rtl}
\alias{str_rtl}
\title{Wrap a string with RTL-embedding Unicode characters}
\usage{
str_rtl(..., multiline = FALSE)
}
\arguments{
\item{...}{One or more character vectors, ideally of length 1.}

\item{multiline}{Whether to split the input strings to separate lines. Defaults to \code{FALSE}.}
}
\value{
A character vector.
}
\description{
Wrap a string with RTL-embedding Unicode characters
}
\examples{
# Notice how the `.` prints to the right, while in RTL it should print to the left
cat("a.")

# `str_rtl()` fixes this:
str_rtl("a.") |> cat()

str_rtl("a.", "b.", multiline = TRUE) |> cat()
}
