% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compatibility.R
\name{rrowl}
\alias{rrowl}
\title{Create an \code{rtable} row from a vector or list of values}
\usage{
rrowl(
  row.name,
  ...,
  format = NULL,
  indent = 0,
  inset = 0L,
  round_type = valid_round_type
)
}
\arguments{
\item{row.name}{(\code{string} or \code{NULL})\cr row name. If \code{NULL}, an empty string is used as \code{row.name} of the
\code{\link[=rrow]{rrow()}}.}

\item{...}{values in vector/list form.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr the format label (string) or formatter function to apply to the
cell values passed via \code{...}. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for currently supported format labels.}

\item{indent}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{inset}{(\code{integer(1)})\cr the table inset for the row or table being constructed. See
\code{\link[formatters:table_inset]{formatters::table_inset()}} for details.}

\item{round_type}{(\code{"iec"}, \code{"iec_mod"} or \code{"sas"})\cr the type of rounding to perform.
See \code{\link[formatters:round_fmt]{formatters::round_fmt()}} for details.}
}
\value{
A row object of the context-appropriate type (label or data).
}
\description{
Create an \code{rtable} row from a vector or list of values
}
\examples{
rrowl("a", c(1, 2, 3), format = "xx")
rrowl("a", c(1, 2, 3), c(4, 5, 6), format = "xx")


rrowl("N", table(iris$Species))
rrowl("N", table(iris$Species), format = "xx")

x <- tapply(iris$Sepal.Length, iris$Species, mean, simplify = FALSE)

rrow(row.name = "row 1", x)
rrow("ABC", 2, 3)

rrowl(row.name = "row 1", c(1, 2), c(3, 4))
rrow(row.name = "row 2", c(1, 2), c(3, 4))

}
\seealso{
Other compatibility: 
\code{\link{rheader}()},
\code{\link{rrow}()},
\code{\link{rtable}()}
}
\concept{compatibility}
