% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_roclet.R
\name{param_roclet}
\alias{param_roclet}
\title{Roclet: check consistency of \code{param} documentation}
\usage{
param_roclet()
}
\value{
A roclet to be used e.g. with \code{\link[roxygen2:roxygenize]{roxygen2::roxygenise()}}
}
\description{
This roclet checks consistency between function arguments
and the documentation. The idea is to catch such errors earlier than in
an R CMD check.

Generally you will not call this function directly
but will instead use \code{\link[roxygen2:roxygenize]{roxygen2::roxygenise()}} specifying this roclet.
}
\examples{
x <- "#' Summing two numbers\n#'\n#' @export\nf <- function(x, y) {\n   x + y\n}\n"
cat(x)
roxygen2::roc_proc_text(param_roclet(), x)

}
\seealso{
Other roclets:
\code{\link{testthat_roclet}},
\code{\link{tinytest_roclet}},
\code{\link{examples_roclet}},
\code{\link{return_roclet}},
\code{\link[roxygen2]{namespace_roclet}},
\code{\link[roxygen2]{rd_roclet}},
\code{\link[roxygen2]{vignette_roclet}}.

Other roclets: 
\code{\link{examples_roclet}()},
\code{\link{return_roclet}()},
\code{\link{testthat_roclet}()},
\code{\link{tinytest_roclet}()}
}
\concept{roclets}
