% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffusion.r
\name{diffuseMat}
\alias{diffuseMat}
\title{Generic diffusion function}
\usage{
diffuseMat(data, ndims = 20, nsig = 5, removeFirst = TRUE,
  useARPACK = TRUE, distfun = NULL, sigmas = NULL, sqdistmat = NULL)
}
\arguments{
\item{data}{Matrix of data with genes in rows and cells in columns.}

\item{ndims}{Number of dimensions to return}

\item{nsig}{For automatic sigma calculation}

\item{removeFirst}{Default TRUE. Removes the first eigenvector}

\item{useARPACK}{Default TRUE. Uses Arnoldi algorithm for eignvector calculations}

\item{distfun}{A different distance function that returns the \strong{squared}
distance}

\item{sigmas}{Manually provide sigma}

\item{sqdistmat}{\strong{Squared} distance matrix.
Give your own squared distance matrix.}
}
\value{
List output containing:
\tabular{rl}{%
  \emph{values} \tab Eigenvalues, excluding the first eigenvalue, which should%
                      always be 1.\cr
   \emph{vectors} \tab Matrix of eigen vectors in columns, first eigen vector%
                       removed.\cr
   \emph{nconv} \tab Number of eigen vectors/values that converged.\cr
   \emph{niter} \tab Iterations taken for Arnoldi algorithm to converge.\cr
   \emph{nops} \tab  Number of operations. \cr
   \emph{val0} \tab 1st eigen value - should be 1. If not be suspicious!\cr
   \emph{vec0} \tab 1st eigen vector - should be \eqn{n^{-\frac{1}{2}}}{1/sqrt(n)},%
                     where n is the number of cells/samples.\cr
   \emph{usedARPACK} \tab Predicates use of ARPACK for spectral decomposition.\cr
   \emph{distfun} \tab Function used to calculate the squared distance.\cr
   \emph{nn} \tab Number of nearest neighbours used for calculating \code{sigmas}.\cr
   \emph{d2} \tab Matrix of squared distances, returned from \code{distfun}.\cr
   \emph{sigmas} \tab Vector of sigmas. Same length as number of cells if individual\cr
                 \tab sigmas were calculated, otherwise a scalar if was supplied.\cr
   \emph{gaussian} \tab Unnormalised transition matrix after applying Gaussian.\cr
   \emph{markov}  \tab Normalised \code{gaussian} matrix.\cr
   \emph{densityCorrected} \tab Matrix after applying density correction to %
                                \code{markov}.\cr
}
}
\description{
Generic diffusion function using automated
individualised sigma calculation
}
\details{
Generic diffusion function using automated individualised sigma calculation.

A Gaussian kernel is applied to the chosen distance metric producing
an \eqn{n \times n} square unnormalised symmetric transition matrix, \eqn{A}.
Let \eqn{D} be an \eqn{n \times n} diagonal matrix with row(column) sums of
\eqn{A} as entries. The density corrected transition matrix will now
be:

\deqn{D^{-1} A D^{-1}}{D^{-1} * A * D^{-1}}

and can be normalised:

\deqn{B^{-1} D^{-1} A D^{-1}}{B^{-1} * D^{-1} * A * D{^-1}}

where \eqn{B} is an \eqn{n \times n} diagonal matrix with row sums of
the density corrected transition matrix as entries. The eigen decomposition of
this matrix can be simplified by solving the symmetric system:

\deqn{B^{-\frac{1}{2}} D^{-1} A D^{-1} B^{-\frac{1}{2}} R^\prime = %
      R^\prime \lambda^\prime}{%
      B^{-0.5} * D^{-1} * A * D^{-1} * B^{-0.5} = R^\prime * L^\prime}

where \eqn{R^\prime}{R^\prime} is a matrix of the right eigenvectors that solve
the system and \eqn{\lambda^\prime}{L'} is the corresponding eigenvalue
diagonal matrix. Now the solution of:

\deqn{B^{-1} D^{-1} A D^{-1} R = R \lambda}{%
      B^{-1} * D^{-1} * A * D^{-1} * R = R * L}

in terms of \eqn{R^\prime} and \eqn{B^{-\frac{1}{2}}} is:

\deqn{B^{-1} D^{-1} A D^{-1} B^{-\frac{1}{2}} R^\prime = %
      B^{-\frac{1}{2}} R^\prime \lambda^\prime}{%
      B^{-1} * D^{-1} * A * D^{-1} * B^{-0.5} = B^{-0.5} * R' * L'}

and

\deqn{R = B^{-\frac{1}{2}} R^\prime}{R = B^{-0.5} * R'}

This \eqn{R} without the first eigen vector is returned as the diffusion map.
}
\examples{
\dontrun{
xx <- diffuseMat(x)
}
}
\references{
Haghverdi, L., Buettner, F., Theis, F.J., 2015. Diffusion maps for high-dimensional single-cell analysis of differentiation data. Bioinformatics 31, 2989–2998.

Haghverdi, L., Büttner, M., Wolf, F.A., Buettner, F., Theis, F.J., 2016. Diffusion pseudotime robustly reconstructs lineage branching. Nat Meth 13, 845–848.

Angerer, P., Haghverdi, L., Büttner, M., Theis, F.J., Marr, C., Buettner, F., 2016. destiny: diffusion maps for large-scale single-cell data in R. Bioinformatics 32, 1241–1243.
}
\author{
Wajid Jawaid
}
