% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_prop.R
\name{update_prop}
\alias{update_prop}
\title{Update a data set with recursively-defined properties}
\usage{
update_prop(
  ds,
  target,
  sources,
  set,
  get,
  combine = function(l) Reduce("+", l),
  override = function(ds, target, v) v
)
}
\arguments{
\item{ds}{data set to be updated}

\item{target}{key of data set element to be updated}

\item{sources}{keys of data set elements to be combined}

\item{set}{function to set properties for a target element called as set(ds, key, value)}

\item{get}{function to get properties for source elements called as get(ds, key)}

\item{combine}{function to combine properties called as combine(vl)}

\item{override}{function to selectively override combined results called as override(ds, key,)}
}
\value{
updated data set
}
\description{
\code{update_prop} calls user-specified methods to get properties
of a source set of elements in a data set, combine those properties,
and set the properties of a target element to the combined value.
If the source set is empty, the data set is returned unmodified. The
default combine operation is addition.

The \code{override} argument can be used to selectively override the
computed value based on the target element. By default, it simply
returns the value computed by the combiner.
}
\examples{
update_prop(wbs_table, "1", list("1.1", "1.2"),
  function(d, k, v) {d[d$id == k, "work"] <- v; d},
  function(d, k) d[d$id == k, "work"]
 )
update_prop(wbs_table, "1", list("1.1", "1.2"),
  function(d, k, v) {d[d$id == k, c("work", "budget")] <- v; d},
  function(d, k) d[d$id == k, c("work", "budget")],
  function(l) Reduce("+", l)
)
}
