% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_simulation.R
\name{add_random_effect}
\alias{add_random_effect}
\title{Add a random effect column for simulation}
\usage{
add_random_effect(design_df, ..., .nesting = NULL)
}
\arguments{
\item{design_df}{A data frame containing the rollout design and any parameters.}

\item{...}{A single named expression specifying the random effect to add (e.g., \code{u = rnorm(1, 0, 1)}).}

\item{.nesting}{Optional character vector specifying grouping columns for nested random effects (default \code{NULL}).}
}
\value{
A \code{tibble} with the added random effect column.
}
\description{
Adds a random effect column (prefixed with \code{"."}) to the design data frame, with optional grouping for nested random effects.
}
\examples{
df <- tibble::tibble(site = rep(1:2, each = 3))
add_random_effect(df, u = rnorm(1, 0, 1), .nesting = "site")
}
