% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoattribute.R
\name{coordinates_to_point}
\alias{coordinates_to_point}
\title{Transform coordinates to point geometry}
\usage{
coordinates_to_point(table, lon_lat = c("intptlon", "intptlat"), crs = NULL)
}
\arguments{
\item{table}{A \code{tibble} object.}

\item{lon_lat}{A vector, name of longitude and latitude attributes.}

\item{crs}{A coordinate reference system: integer with the EPSG code, or
character with proj4string.}
}
\value{
A \code{sf} object.
}
\description{
From the coordinates defined in fields such as latitude and longitude, it
returns a layer of points.
}
\details{
If we start from a geographic layer, it initially transforms it into a table.

The CRS of the new layer is indicated. If a CRS is not indicated, it
considers the layer's CRS by default and, if it is not a layer, it considers
4326 CRS (WGS84).
}
\examples{

us_state_point <-
  coordinates_to_point(us_layer_state,
                       lon_lat = c("INTPTLON", "INTPTLAT"))

}
\concept{level definition functions}
