% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database_export.R
\name{as_xlsx_file}
\alias{as_xlsx_file}
\alias{as_xlsx_file.star_database}
\title{Generate a xlsx file with fact and dimension tables}
\usage{
as_xlsx_file(db, file)

\method{as_xlsx_file}{star_database}(db, file = NULL)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{file}{A string, name of a file.}
}
\value{
A string, name of a file.
}
\description{
To port databases to other work environments it is useful to be able to
export them as a xlsx file, as this function does.
}
\examples{
\donttest{
db1 <- star_database(mrs_cause_schema, ft_num) |>
  snake_case()
tl1 <- db1 |>
  as_xlsx_file()

db2 <- star_database(mrs_age_schema, ft_age) |>
  snake_case()

ct <- constellation("MRS", db1, db2)
f <- ct |>
  as_xlsx_file(file = tempfile())
}
}
\seealso{
\code{\link{star_database}}

Other star database exportation functions: 
\code{\link{as_csv_files}()},
\code{\link{as_dm_class}()},
\code{\link{as_multistar}()},
\code{\link{as_rdb}()},
\code{\link{as_single_tibble_list}()},
\code{\link{as_tibble_list}()},
\code{\link{draw_tables}()}
}
\concept{star database exportation functions}
