% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_plantremains.R
\name{road_get_plantremains}
\alias{road_get_plantremains}
\title{Get paleobotany data from the ROAD database}
\usage{
road_get_plantremains(
  continent = NULL,
  subcontinent = NULL,
  country = NULL,
  locality_type = NULL,
  cultural_period = NULL,
  technocomplex = NULL,
  category = NULL,
  age_min = NULL,
  age_max = NULL,
  assemblages = NULL,
  plant_remains = NULL,
  plant_family = NULL,
  plant_genus = NULL,
  plant_species = NULL
)
}
\arguments{
\item{continent}{specifies the continent(s) (e.g. Africa, Europe, Asia).
Run \code{road_list_argument_values("continent")} to display possible values.
The argument \code{continent} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{subcontinent}{specifies the continental region(s) (e.g. Southern Europe).
Run \code{road_list_argument_values("subcontinent")} to display possible values.
The argument \code{subcontinent} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{country}{specifies the name of the country where a locality is situated
(e.g. Germany, Kenya, Saudi Arabia). Run \code{road_list_argument_values("country")}
to display possible values.
The argument \code{country} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{locality_type}{specifies the type of locality (e.g. cave, rockshelter, open air).
Run \code{road_list_argument_values("locality_type")} to display possible values.
The argument \code{locality_type} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{cultural_period}{specifies the main cultural epoch(s) and includes the
Eurasian Paleolithic (Lower, Middle, Upper, Epi-) and the African Stone Age
(Earlier, Middle, Later). Run \code{road_list_argument_values("cultural_period")}
to display possible values. The argument \code{cultural_period} is a string
(one item) or vector of strings (one or more items); defaults to NULL.}

\item{technocomplex}{specifies an archaeological culture or named stone tool
industry (e.g. Oldowan, Acheulean, Mousterian).
Run \code{road_list_argument_values("technocomplex")} to display possible values.
The argument \code{technocomplex} is a string (one item) or vector of strings
(one or more items); defaults to NULL.}

\item{category}{specifies the assemblage category with the classes
human remains, raw material, typology, technology, function, organic tools,
symbolic artifacts, feature, miscellaneous finds, paleofauna, animal remains,
plant remains. The argument \code{category} is a string (one item) or
vector of strings (one or more items); defaults to NULL.}

\item{age_min}{specifies the minimum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_min} will be converted to 
an integer; defaults to NULL.}

\item{age_max}{specifies the maximum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_max} will be converted to 
an integer; defaults to NULL.}

\item{assemblages}{specifies a data frame necessarily containing columns 
locality_id, assemblage_id. It can be  generated as return value of the 
function 'road_get_assemblages'. It can be used instead of the locality 
and assemblage search parameters to filter the results.}

\item{plant_remains}{specifies the type of plant remains. Possible entries
include: "pollen", "plant macroremains" etc. Run
\code{road_list_argument_values("plant_remains")} to display
possible values. The argument \code{plant_remains} is a string (one item) or vector of
strings; defaults to NULL.}

\item{plant_family}{specifies the family to which the described plant remains
is attributed to. Possible entries include: "Poaceae", "Typhaceae" etc.
Run \code{road_list_argument_values("plant_family")} to display
possible values. The argument \code{plant_family} is a string (one item) or
vector of strings; defaults to NULL.}

\item{plant_genus}{specifies the genus name of the taxon.
Run \code{road_list_argument_values("plant_genus")} to display
possible values. The argument \code{plant_genus} is a string (one item) or
vector of strings; defaults to NULL.}

\item{plant_species}{specifies the full and valid species name including
author’s name (e.g. Quercus ilex L., Sciadopitys verticillata (Thunb.)
Siebold & Zucc). Run \code{road_list_argument_values("plant_species")}
to display possible values. The argument \code{plant_species} is a string
(one item) or vector of strings; defaults to NULL.}
}
\value{
A data frame with plant remains information. Rows represent individual
plant remains finds, columns contain standard outputs and plant remains-related details on:

\code{plant_remains}: The attribute specifies the type of plant remains 
(e.g. pollen, plant macroremains).

\code{plant_family}, \code{plant_genus}, \code{plant_species}: 
The attributes specify the taxonomic classification of the plant remains.
}
\description{
The function  \strong{\code{road_get_plantremains}} retrieves data on paleobotanical remains from the ROAD database.
Paleobotanical remains are plant remains found in archaeological contexts and are associated with
assemblages.
}
\details{
This function allows you to query paleobotanical data based on
various parameters such as geographical location, cultural periods, plant taxonomy,
and assemblages. Use the parameters to filter the results or omit them to retrieve a broader dataset.
Genus and species parameters can be entered as a vector of strings to search for multiple entries.
If genus and species are both specified, most of the time it's more sensible to enter them as
single strings and not as vectors with multiple search words to receive useful results.
}
\examples{
\donttest{road_get_plantremains(subcontinent = "Central Asia", plant_family = "Poaceae", 
                      plant_genus = "Setaria")}
\donttest{road_get_plantremains(country = c("Israel"), plant_remains = "starch")}
}
