% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/study.perc.contrib_function.R
\name{study_perc_contrib}
\alias{study_perc_contrib}
\title{Calculate study percentage contributions to summary treatment effects or
regression coefficients}
\usage{
study_perc_contrib(
  study_name,
  base_t,
  exp_t,
  ref_t,
  obs_se,
  obs_cov = NULL,
  covar,
  covar_assum,
  model,
  tau = NULL,
  tau_beta = NULL
)
}
\arguments{
\item{study_name}{A vector of labels with the names of the studies included
in the investigated network. For multi-arm studies, the study name should
appear as many times as the number of possible comparisons among the
compared treatments.}

\item{base_t}{A vector of numbers referring to the treatment identifier for
the baseline arm (comparator) of each study.}

\item{exp_t}{A vector of numbers referring to the treatment identifier for
the experimental arm of each study.}

\item{ref_t}{A scalar for the selected reference treatment in the network.}

\item{obs_se}{A vector of numbers referring to the estimated standard error
of the treatment effect of each study. For multi-arm studies, the standard
error of the treatment effect of each possible  comparison among the
compared treatments should be included.}

\item{obs_cov}{A vector of numbers referring to the covariance in the block
variance-covariance matrix of the estimated treatments effects for the
multi-arm studies only. This argument should be left unspecified if there
are no multi-arm studies in the network.}

\item{covar}{A vector of numbers referring to a continuous covariate that
indicates a study characteristic or summary patient characteristic.}

\item{covar_assum}{Character string indicating the structure of the
treatment-by-covariate interaction, as described in Cooper et al. (2009) if
interest also lies on the study percentage contributions to the estimated
regression coefficients. Set \code{covar_assumption} equal to \code{"no"},
\code{"exchangeable"}, \code{"independent"}, or \code{"common"}. When
\code{covar_assum = "no"}, only the study percentage contributions to the
summary treatment effects will be calculated. There is no default argument.}

\item{model}{Character string indicating the analysis model with values
\code{"RE"}, or \code{"FE"} for the random-effects and fixed-effect model,
respectively. There is no default argument.}

\item{tau}{A scalar referring to the estimated between-study standard
deviation obtained from network meta-analysis,
if \code{covar_assum = "no"}, or network meta-regression for a specific
treatment-by-covariate interaction assumption.  This argument should be
left unspecified when \code{model = "FE"}.}

\item{tau_beta}{A scalar referring to the estimated standard
deviation of the exchangeable regression coefficients obtained from
network meta-regression with exchangeable treatment-by-covariate
interaction. This argument should be left unspecified when
\code{covar_assum} is not "exchangeable". There is no default argument.}
}
\value{
A list of the following two elements:
  \item{perc_contribute}{A data-frame with four columns referring to the
  study name, baseline and experimental treatment arm, and the covariate and
  as many columns as the number of possible comparisons with the study
  percentage contributions to summary treatment effects referring to the
  basic parameters, and followed by the functional parameters. If interest
  lies also on the regression coefficients, extra columns appear referring to
  the study percentage contributions to the regression coefficients specified
  from the argument \code{covar_assum}.}
  \item{covar_assumption}{The estimated summary odd ratio in the logarithmic scale when
  \code{measure = "RR"} or \code{measure = "RD"}.}
}
\description{
A data-frame on the percentage contributions of each study to every possible
pairwise comparison in the investigated network. Study percentage
contributions are based on the proposed methodology of Donegan and colleagues
(2018).
}
\details{
Note that the columns referring to the study percentage contributions to
summary treatment effects are indicated by the letter 'd' with two numbers in
decreasing order for the comparison: the first number refers to the
comparator and the second number refers to the experimental treatment of the
comparison. If interest lies also on the regression coefficients, the
correspoding columns are indicated by 'beta'.

The function centers the covariate to the mean but presents the original
version of the covariate.
}
\examples{
data("nma.malaria.donegan2018")

# Get study contributions to fixed-effect network meta-regression
# results under the assumption of independent treatment-by-covariate
# interaction
study_perc_contrib(study_name = nma.malaria.donegan2018$s,
                   base_t = nma.malaria.donegan2018$t1,
                   exp_t = nma.malaria.donegan2018$t2,
                   ref_t = 1,
                   obs_se = nma.malaria.donegan2018$se,
                   covar = nma.malaria.donegan2018$x,
                   covar_assum = "independent",
                   model = "FE")

}
\references{
Cooper NJ, Sutton AJ, Morris D, Ades AE, Welton NJ. Addressing between-study
heterogeneity and inconsistency in mixed treatment comparisons: Application
to stroke prevention treatments in individuals with non-rheumatic atrial
fibrillation. \emph{Stat Med} 2009;\bold{28}(14):1861--81.
doi: 10.1002/sim.3594

Donegan S, Dias S, Tudur-Smith C, Marinho V, Welton NJ. Graphs of study
contributions and covariate distributions for network meta-regression.
\emph{Res Synth Methods} 2018;\bold{9}(2):243--60. doi: 10.1002/jrsm.1292
}
\author{
{Loukia M. Spineli}
}
