% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{colon_lev}
\alias{colon_lev}
\title{A dataset from a landmark colon cancer trial}
\format{
A data frame with 915 rows and 6 variables:
\describe{
  \item{id}{Unique patient ID.}
  \item{time}{Event time (years).}
  \item{status}{Event type; 1 = cancer relapse, 2 = death.}
  \item{rx}{"Lev+5FU" = combined treatment, "Control" = control.}
  \item{age}{Patient age (years) at randomization.}
  \item{sex}{0 = female, 1 = male.}
  }
}
\usage{
colon_lev
}
\description{
A landmark colon cancer trial on the efficacy of levamisole and fluorouracil
was reported by Moertel et al. (1990). The trial recruited 929 patients with stage C disease
and randomly assigned them to levamisole treatment alone, levamisole combined with fluorouracil,
and the control. The dataset here is restricted to the comparison between the combined treatment
and control groups, consisting of 304 and 314 patients, respectively.
}
\references{
MOERTEL, C. G., FLEMING, T. R., MACDONALD, J. S., HALLER, D. G., LAURIE, J. A., GOODMAN, P. J.,
UNGERLEIDER, J. S., EMERSON, W. A., TORMEY, D. C., GLICK, J. H. et al. (1990). Levamisole and fluorouracil
 for adjuvant therapy of resected colon carcinoma. New Engl. J. Med. 322, 352--358.
}
\keyword{datasets}
