% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_main.R
\name{plot_clinical_impact}
\alias{plot_clinical_impact}
\title{Plot the clinical impact curve from a DecisionCurve object.}
\usage{
plot_clinical_impact(x, population.size = 1000, cost.benefit.axis = TRUE,
  n.cost.benefits = 6, cost.benefits, confidence.intervals, col = "black",
  lty = 1, lwd = 2, xlim, ylim, xlab, ylab,
  cost.benefit.xlab = "Cost:Benefit Ratio", legend.position = c("topright",
  "right", "bottomright", "bottom", "bottomleft", "left", "topleft", "top",
  "none"), ...)
}
\arguments{
\item{x}{decision_curve object to plot. Assumes output from function 'decision_curve'}

\item{population.size}{Hypothetical population size (default 1000).}

\item{cost.benefit.axis}{logical (default TRUE) indicating whether to print an additional x-axis showing relative cost:benefit ratios in addition to risk thresholds.}

\item{n.cost.benefits}{number of cost:benefit ratios to print if cost.benefit.axis = TRUE (default n.cost.benefit = 6).}

\item{cost.benefits}{Character vector of the form c("c1:b1", "c2:b2", ..., "cn:bn") with integers ci, bi corresponding to specific cost:benefit ratios to print. Default allows the function to calculate these automatically.}

\item{confidence.intervals}{logical indicating whether to plot confidence intervals.}

\item{col}{vector of length two indicating the color for the number high risk and the second to the number high risk with outcome, respectively.}

\item{lty}{vector of linetypes. The first element corresponds to the number high risk and the second to the number high risk with outcome.}

\item{lwd}{vector of linewidths. The first element corresponds to the number high risk and the second to the number high risk with outcome.}

\item{xlim}{vector giving c(min, max) of x-axis. Defaults to c(min(thresholds), max(thresholds)).}

\item{ylim}{vector giving c(min, max) of y-axis.}

\item{xlab}{label of main x-axis.}

\item{ylab}{label of y-axis.}

\item{cost.benefit.xlab}{label of cost:benefit ratio axis.}

\item{legend.position}{character vector giving position of legend. Options are "topright" (default), "right", "bottomright", "bottom", "bottomleft", "left", "topleft", "top", or "none".}

\item{...}{other options directly send to plot()}
}
\description{
For a given population size, plot the number of subjects classified as high risk, and the number of subjects classified high risk with the outcome of interest at each high risk threshold.
}
\examples{
#'data(dcaData)
set.seed(123)
baseline.model <- decision_curve(Cancer~Age + Female + Smokes,
                                data = dcaData,
                                thresholds = seq(0, .4, by = .001),
                                bootstraps = 25) #should use more bootstrap replicates in practice!

#plot the clinical impact
plot_clinical_impact(baseline.model, xlim = c(0, .4),
                    col = c("black", "blue"))

}
