% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{cran_packages}
\alias{cran_packages}
\title{Retrieve the List of CRAN Packages (Internal)}
\usage{
cran_packages(cache = TRUE)
}
\arguments{
\item{cache}{Logical. If \code{TRUE} (default), the result is cached using \code{memoise::memoise()} 
with a timeout of 30 minutes to avoid repeated downloads. If \code{FALSE}, the metadata is fetched 
directly from CRAN each time the function is called.}
}
\value{
A matrix of package metadata similar to the output of \code{utils::available.packages()},
with package names as row names.
}
\description{
Downloads and caches the current list of packages available on CRAN.
}
\details{
The function downloads the \code{packages.rds} file from the CRAN website,
which contains metadata about all available packages. The result is cached using
\code{memoise::memoise()} with a timeout of 30 minutes.
}
\examples{
\donttest{
pkgs <- cran_packages()
head(rownames(pkgs))
}

}
