% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfm-plots.R
\name{rfm_plot_bar_chart}
\alias{rfm_plot_bar_chart}
\alias{rfm_bar_chart}
\title{RFM bar chart}
\usage{
rfm_plot_bar_chart(
  rfm_table,
  bar_color = NULL,
  xaxis_label = NULL,
  sec_xaxis_label = NULL,
  yaxis_label = NULL,
  sec_yaxis_label = NULL,
  print_plot = TRUE
)
}
\arguments{
\item{rfm_table}{An object of class \code{rfm_table}.}

\item{bar_color}{Color of the bars.}

\item{xaxis_label}{X axis label.}

\item{sec_xaxis_label}{Secondary x axis label.}

\item{yaxis_label}{Y axis label.}

\item{sec_yaxis_label}{Secondary y axis label.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a
plot object.}
}
\value{
Bar chart.
}
\description{
Examine the distribution of monetary scores for the different
  combinations of frequency and recency scores.
}
\section{Deprecated Functions}{

\code{rfm_bar_chart()} has been deprecated and will be made defunct. It has
been provided for compatibility with older versions only, and will be made
defunct at the next release.

Instead use the replacement function \code{rfm_plot_bar_chart()}.
}

\examples{
# using transaction data
analysis_date <- as.Date('2006-12-31')
rfm_order <- rfm_table_order(rfm_data_orders, customer_id, order_date,
revenue, analysis_date)

# bar chart
rfm_plot_bar_chart(rfm_order)

}
