% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recmap.R
\name{recmapGRASP}
\alias{recmapGRASP}
\title{Greedy Randomized Adaptive Search Procedure Wrapper Function for recmap}
\usage{
recmapGRASP(
  Map,
  fitness = .recmap.fitness,
  n.samples = nrow(Map) * 2,
  fitness.cutoff = 1.7,
  iteration.max = 10
)
}
\arguments{
\item{Map}{input map, see \link[recmap]{recmap}.}

\item{fitness}{a fitness function \code{function(idxOrder, Map, ...)} returning a number which as to be maximized.}

\item{n.samples}{number of samples.}

\item{fitness.cutoff}{cut-off value}

\item{iteration.max}{defines the maximal number of iterations.}
}
\value{
returns a list of the input \code{Map}, the best solution of GRASP, and a \code{\link[recmap]{recmap}} object containing the cartogram.
}
\description{
Implements a metaheuristic for \code{\link[recmap]{recmap}} based on GRASP.
}
\examples{
\dontrun{
  recmap::.getUS_map() |> recmapGRASP() -> res;
  plot(res$Map, main = "Input Map");
  plot(res$Cartogram, main = "Output Cartogram")
}
}
\references{
\doi{10.1007/BF01096763}
}
\seealso{
\code{\link[recmap]{recmapGA}} and \code{\link[recmap]{recmap}}
}
\author{
Christian Panse, 2016
}
