#' Distribuția numărului de ore/zi la clase, cu o anumită diferență între zile
#'
#' Avem de urmărit ca lecțiile fiecărei clase să fie distribuite omogen, 
#' (și nu cvasi-omogen) pe zile.
#'
#' @param DZ Distribuția curentă pe zile, a tuturor lecțiilor
#' @param d Diferența între cel mai mare și cel mai mic număr de ore/zi
#' @return Matrice în care pe fiecare linie avem distribuția numărului
#'     de ore/zi pentru câte o clasă, dacă există diferențe de 'd' ore
#'     între o zi și alta ('NULL' dacă nu există astfel de clase).
#' @export

cls_quasihom <- function(DZ, d = 2) {
    tcz <- table(DZ[c('cls','zl')])
    cdf <- apply(tcz, 1, function(row) if(diff(range(row)) == d) row) %>%
           compact()
    if(is.null(cdf)) return(NULL)
    list2DF(cdf) %>% as.matrix() %>% 
        t() %>% `colnames<-`(Zile)
}
