% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{test_dir}
\alias{test_dir}
\title{Gather All Test Results From R Scripts}
\usage{
test_dir(
  path = "tests",
  pattern = "^realtest-.*\\\\.R$",
  recursive = FALSE,
  ignore.case = FALSE
)
}
\arguments{
\item{path}{directory with scripts to execute}

\item{pattern}{regular expression specifying the file names to execute}

\item{recursive}{logical, see \code{\link[base]{list.files}}}

\item{ignore.case}{logical, see \code{\link[base]{list.files}}}
}
\value{
Returns a list of all test results
(of class \code{realtest_results}),
each being an object of class \code{realtest_result}, see \code{\link{E}},
with additional fields \code{.file}, \code{.line}, and \code{.expr},
giving the location and the source code of the test instance.
}
\description{
Executes all R scripts in a given directory whose names match a given
pattern and gathers all test result in a single list,
which you can process however you desire.

The function does not fail if some tests are not met -- you need
to detect this yourself.
}
\examples{
# r <- test_dir("~/R/realtest/inst/realtest")  # some path
# s <- summary(r)  # summary.realtest_results
# print(s)  # print.realtest_results_summary
# stopifnot(!any(s[["match"]]=="fail"))  # halt if there are failed tests

}
\seealso{
The official online manual of \pkg{realtest} at \url{https://realtest.gagolewski.com/}

Related functions:
\code{\link{source2}}, \code{\link{summary.realtest_results}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
