% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sens_plot.R
\name{sens_plot}
\alias{sens_plot}
\title{Plot the Simulated Estimates for Sensitivity Analyses}
\usage{
sens_plot(
  sim_results,
  level = 0.95,
  x = c("A1", "A2", "bw"),
  plot_models = unique(sim_results$model),
  yrange = NULL
)
}
\arguments{
\item{sim_results}{A \code{data.frame} returned by \code{rd_sens_cutoff}, \code{rd_sens_bw},
\code{mrd_sens_cutoff}, or \code{mrd_sens_bw}.}

\item{level}{A numeric value between 0 and 1 specifying the confidence level for CIs (assuming a normal sampling distribution). The default is 0.95.}

\item{x}{A string of the column name of the varying parameter in \code{sim_results}. 
This will be used as the x-axis in the plot. Possible values are \code{c("A1", "A2", "bw")}, 
which are column names in \code{sim_results}. 
\code{A1} specifies that the varying cutoffs are for assignment 1 and \code{A2} specifies assignment 2.
\code{bw} indicates that the varying parameter is bandwidth.}

\item{plot_models}{A character vector specifying the models to be plotted (i.e. models estimated with 
different approaches). Possible values are \code{unique(sim_results$model))}.}

\item{yrange}{An optional numeric vector specifying the range of the y-axis.}
}
\description{
\code{sens_plot} plots the sensitivity analysis for cutpoints or bandwidths.
}
\examples{
set.seed(12345)
x <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * x + 3 * cov + 10 * (x >= 0) + rnorm(1000)
m <- rd_est(y ~ x | cov, t.design = "geq")
sim_cutoff <- rd_sens_cutoff(m, seq(-.5, .5, length.out = 10))
sens_plot(sim_cutoff, x = "A1", plot_models = c("linear", "optimal"))
sim_bw <- rd_sens_bw(m, seq(.1, 1, length.out = 10))
sens_plot(sim_bw, x = "bw")
}
