% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate_planar.R
\name{interpolate_planar}
\alias{interpolate_planar}
\title{Interpolate in planar space}
\usage{
interpolate_planar(sky_points, r, k = 3, p = 2, rmax = 200, col_id = "dn")
}
\arguments{
\item{sky_points}{\code{data.frame} with columns \code{row}, \code{col}, and one additional
numeric column with values to interpolate. Typically returned by
\code{\link[=extract_rr]{extract_rr()}} or \code{\link[=extract_dn]{extract_dn()}}.}

\item{r}{numeric \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer. Image from which
\code{sky_points} were derived, or another raster with the same number of rows
and columns. Used only as geometric template; cell values are ignored.}

\item{k, p, rmax}{numeric vector of length one. Parameters passed to
\code{\link[lidR:dtm_idw]{lidR::knnidw()}}: number of neighbors (\code{k}), inverse distance weighting
exponent (\code{p}), and maximum search radius (\code{rmax}) in units of the output
resolution.}

\item{col_id}{numeric or character vector of length one. The name or position
of the column in \code{sky_points} containing the values to interpolate.}
}
\value{
Numeric \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer and the same geometry
as \code{r}.
}
\description{
Interpolate values from canopy photographs using inverse distance weighting
(IDW) with k-nearest neighbors in image (planar) coordinates.
A radius limits neighbor search.
}
\details{
Delegates interpolation to \code{\link[lidR:dtm_idw]{lidR::knnidw()}}, passing \code{k}, \code{p}, and \code{rmax}
unchanged. Defaults follow \insertCite{Lang2013;textual}{rcaiman}.
Note that \code{rmax} is given in pixels but intended to approximate 15–20 deg in
angular terms. Therefore, this value needs fine-tuning based on image
resolution and lens projection. For best results, the interpolated quantity
should be linearly related to scene radiance; see \code{\link[=extract_radiometry]{extract_radiometry()}} and
\code{\link[=read_caim_raw]{read_caim_raw()}}. For JPEG images, consider \code{\link[=invert_gamma_correction]{invert_gamma_correction()}} to reverse gamma
encoding.
}
\note{
No consistency checks are performed to ensure that \code{sky_points} and \code{r}
are geometrically compatible. Incorrect combinations may lead to invalid
outputs.
}
\examples{
\dontrun{
caim <- read_caim()
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
m <- !is.na(z)
r <- caim$Blue

bin <- binarize_by_region(r, ring_segmentation(z, 15), "thr_isodata") &
  select_sky_region(z, 0, 88)

g <- sky_grid_segmentation(z, a, 10)
sky_points <- extract_sky_points(r, bin, g, dist_to_black = 3)
plot(bin)
points(sky_points$col, nrow(caim) - sky_points$row, col = 2, pch = 10)
sky_points <- extract_dn(r, sky_points)

sky <- interpolate_planar(sky_points, r, col_id = 3)
plot(sky)
plot(r/sky)
}
}
\references{
\insertAllCited{}
}
