% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_DEA.R
\name{robust_DEA}
\alias{robust_DEA}
\title{Robust Data Envelopment Analysis (DEA)}
\usage{
robust_DEA(
  input,
  output,
  m,
  B,
  RTS = "crs",
  ORIENTATION = "in",
  alpha = FALSE,
  inclusion = FALSE,
  print = FALSE
)
}
\arguments{
\item{input}{matrix (or vector) of inputs along which the units are evaluated.}

\item{output}{matrix (or vector) of outputs along which the units are evaluated.}

\item{m}{number of unit to be included in the reference set}

\item{B}{number of bootstrap replicates}

\item{RTS}{For more details see the dea function in the package Benchmarking. Text string or a number defining the underlying DEA technology / returns to scale assumption.
0    fdh    Free disposability hull, no convexity assumption
1    vrs    Variable returns to scale, convexity and free disposability
2    drs    Decreasing returns to scale, convexity, down-scaling and free disposability
3    crs    Constant returns to scale, convexity and free disposability
4    irs    Increasing returns to scale, (up-scaling, but not down-scaling), convexity and free disposability
5    irs2    Increasing returns to scale (up-scaling, but not down-scaling), additivity, and free disposability
6    add    Additivity (scaling up and down, but only with integers), and free disposability; also known af replicability and free disposability, the free disposability and replicability hull (frh) -- no convexity assumption
7    fdh+    A combination of free disposability and restricted or local constant return to scale
10    vrs+    As vrs, but with restrictions on the individual lambdas via param}

\item{ORIENTATION}{For more details see the dea function in the package Benchmarking. Input efficiency "in" (1), output efficiency "out" (2), and graph efficiency "graph" (3). For use with DIRECT, an additional option is "in-out" (0).}

\item{alpha}{This allow to choose the size of the Confidence Intervals computed. By defaulta alpha = FALSE. In this case no confidence interval are computed}

\item{inclusion}{If inclusion = TRUE the unit under analysis is included in the reference set. So, no super efficient scores are allowed. By default inclusion = FALSE.}

\item{print}{If print = TRUE the number of the unit under evaluation is printed. In case of large sample the function could require some time, so it could be useful to control how many units have already been evaluated and which one still have to be evaluated. By default print = FALSE.}
}
\value{
If the parameter alpha is specified, the function returns a data frame with three numeric columns.
The first column is the vector representing the robust DEA scores (eff);
the second column is the vector representing the lower bound of the condifence interval (ci_low);
the third column is the vector representing the upper bound of the confidence interval (Ci_up).
If alpha is not specified, the functions returns only the first column of the data frame (eff).
}
\description{
This function allows to compute Robust  DEA scores.
}
\examples{
#Example with a very small sample to decrease computational time.
          x1 <-runif(50, 50, 75)
          x2 <-runif(50, 30, 75)
          x <- cbind(x1, x2)
          e <- rnorm(50, 0, 36)
          a1 <- 0.4
          a2 <- 0.6
          y <- a1*x1 + a2*x2 + e

          #Robust DEA
          r_DEA <- robust_DEA(input = x, output = y, m = 20, B = 50,
          RTS = "crs", ORIENTATION = "in", print = TRUE)
          summary(r_DEA$eff)

\donttest{ #Example with random data x and y
          x1 <-runif(100, 50, 75)
          x2 <-runif(100, 30, 75)
          x <- cbind(x1, x2)
          y <- cbind(x+runif(100, -10, 0), rnorm(100, 15, 4))

          #Robust DEA
          r_DEA <- robust_DEA(input = x, output = y, m = 30, B = 40,
          RTS = "crs", ORIENTATION = "in", print = TRUE)
          summary(r_DEA$eff) }

}
\concept{Robust Data Envelopment Analysis}
