% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-futures.R
\name{futures_get}
\alias{futures_get}
\title{Retrieves B3 Futures Settlement Prices}
\source{
\href{https://www.b3.com.br/en_us/market-data-and-indices/data-services/market-data/historical-data/derivatives/trading-session-settlements/}{B3 Market Data}
}
\usage{
futures_get()
}
\value{
An \code{arrow_dplyr_query} or \code{ArrowObject}, representing a lazily evaluated query. The underlying data is not
collected until explicitly requested, allowing efficient manipulation of large datasets without immediate
memory usage.
To trigger evaluation and return the results as an R \code{tibble}, use \code{collect()}.

The returned data includes the following columns:
\itemize{
\item \code{refdate}: Reference date for the prices.
\item \code{symbol}: Futures contract symbol, created by concatenating the commodity code and the maturity code.
\item \code{commodity}: Commodity code of the futures contract.
\item \code{maturity_code}: Maturity code of the futures contract.
\item \code{previous_price}: Closing price from the previous trading day.
\item \code{price}: Current price of the futures contract.
\item \code{price_change}: Price variation compared to the previous day.
\item \code{settlement_value}: Settlement value of the futures contract.
}
}
\description{
This function fetches settlement price data for B3 futures contracts.
This function retrieves futures settlement prices from the B3 dataset,
adding a \code{symbol} column that combines \code{commodity} and \code{maturity_code}.
}
\examples{
\dontrun{
df_fut <- futures_get() |> filter(refdate == Sys.Date()) |> collect()
head(df_fut)
}
}
