% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ktotal.R
\name{Ktotal}
\alias{Ktotal}
\title{Calculates Total Wavenumber for Rossby Waves (K)}
\usage{
Ktotal(
  u,
  lat = "lat",
  lon = "lon",
  uname = "uwnd",
  cx,
  ofile,
  a = 6371000,
  plots = FALSE,
  show.warnings = FALSE
)
}
\arguments{
\item{u}{String indicating the input data filename. The file to be
passed consists in a netCDF file with only time-mean zonal wind at one
pressure level, latitude in ascending order (not a requisite), and longitude
from 0 to 360. It is required that the read dimensions express
longitude (in rows) x latitude (in columns).
\strong{u} also can be a numerical matrix with time-mean zonal wind at one
pressure level, latitude in ascending order (not a requisite), and longitude
from 0 to 360. It is required that the read dimensions express longitude
(in rows) x latitude (in columns).}

\item{lat}{String indicating the name of the latitude field. If
\strong{u} is a matrix, \strong{lat} must be numeric}

\item{lon}{String indicating the name of the longitude field.If
\strong{u} is a matrix, \strong{lon} must be numeric from 0 to 360.}

\item{uname}{String indicating the variable name field}

\item{cx}{numeric. Indicates the zonal phase speed. Must be greater than zero.
For cx equal to zero (stationary waves see \code{\link{Ks}})}

\item{ofile}{String indicating the file name for store output data.
If missing, will not return a netCDF file}

\item{a}{Numeric indicating the Earth's radio (m)}

\item{plots}{Logical, if TRUE will produce filled.countour plots}

\item{show.warnings}{Logical, if TRUE will warns about NaNs in sqrt(<0)}
}
\value{
list with one vector (lat) and 1 matrix (ktotal_m)
}
\description{
\code{Ktotal} ingests the time-mean zonal wind (u) and calculates the Rossby
wavenumber (K) (non-zero frequency waves) in mercator coordinates.
In this code Ktotal is used to distinguish the total wavenumber (K) from
zonal wave number (k). For stationary Rossby Waves, please see \code{\link{Ks}}.
\code{Ktotal} returns a list with K in mercator coordinates (ktotal_m).
}
\examples{
{
# u is NetCDF and lat and lon characters
input <- system.file("extdata",
                     "uwnd.mon.mean_200hPa_2014JFM.nc",
                      package = "raytracing")
Ktotal <- Ktotal(u = input, cx = 6, plots = TRUE)
cores <- c("#ff0000","#ff5a00","#ff9a00","#ffce00","#f0ff00")
graphics::filled.contour(Ktotal$ktotal_m[, -c(1:5, 69:73)] ,
                         col = rev(colorRampPalette(cores, bias = 0.5)(20)),
                         main = "K")
}
}
