% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pielou.R
\name{Pielou}
\alias{Pielou}
\title{Pielou's Evenness Index}
\usage{
Pielou(
  x,
  window = 3,
  rasterOut = TRUE,
  np = 1,
  na.tolerance = 1,
  cluster.type = "SOCK",
  debugging = FALSE
)
}
\arguments{
\item{x}{A raster object (matrix, SpatRaster, SpatialGridDataFrame, or a list containing one of these).}

\item{window}{The size of the moving window to be used for the calculation. Must be an odd integer.}

\item{rasterOut}{Logical, if TRUE the output will be a raster object; if FALSE a matrix.}

\item{np}{The number of processes to use in parallel mode. If np > 1, parallel computation is enabled.}

\item{na.tolerance}{The tolerance level for NA values within the moving window, expressed as a proportion (0 to 1).}

\item{cluster.type}{The type of cluster to use for parallel computation (e.g., "SOCK", "FORK").}

\item{debugging}{Logical, if TRUE debugging information will be printed.}
}
\value{
Returns a raster object or matrix containing the Pielou's Evenness Index values.
}
\description{
Calculates Pielou's Evenness Index for a given raster object over a specified window size. The function can operate in either sequential or parallel mode.
}
