% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_rankings.R
\name{to_rankings}
\alias{to_rankings}
\title{Convert ranks into rankings (orderings)}
\usage{
to_rankings(ranks, assignments = NULL, rankings = NULL)
}
\arguments{
\item{ranks}{A matrix or vector of ranks, such that the (i,j) entry includes the rank given by judge i to proposal j.
\code{NA} is used to indicate that no rank was assigned to a proposal, which may occur for two reasons: (1)
If the \code{assignments} matrix is not specified or the (i,j) entry of assignments is \code{TRUE}, then an \code{NA} indicates that
a proposal was considered worse than all ranked proposals. (2) If the (i,j) entry of \code{assignments} is \code{FALSE}, then \code{NA}
indicates that a proposal was not considered by the judge and no information can be gleaned from the missing rank.}

\item{assignments}{A matrix of booleans, such that the (i,j) entry is \code{TRUE} if judge i was assigned to review proposal j, and
\code{FALSE} otherwise. If \code{assignments} is \code{NULL}, we assume all judges considered all proposals.}

\item{rankings}{A matrix or vector of rankings. If a matrix, there should be one ranking per row.}
}
\value{
A matrix of rankings, with one row per ranking. If \code{assignments} argument is specified, then the rankings matrix will have
the attribute "assignments".
}
\description{
This function converts a matrix of ranks into a matrix of rankings (i.e., orderings), potentially including reviewer
assignments as an attribute of the ranking matrix. Additionally, it can be used to add an assignments matrix to an existing
matrix of rankings.
}
\examples{
ranks <- matrix(data=c(4,2,3,1,NA,1,2,3,NA,NA,1,NA),byrow=TRUE,nrow=3)
assignments=matrix(TRUE,byrow=TRUE,nrow=3,ncol=4)
to_rankings(ranks=ranks)
to_rankings(ranks=ranks,assignments=assignments)
to_rankings(assignments=matrix(TRUE,nrow=1,ncol=3),rankings=c(3,2,1))

}
