% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryChEA3.R
\name{queryChEA3}
\alias{queryChEA3}
\title{Query ChEA3 API for TF enrichment}
\usage{
queryChEA3(genes, query_name = "rChEA3_query", verbose = TRUE)
}
\arguments{
\item{genes}{Character vector of HGNC gene symbols.}

\item{query_name}{Optional query name (default: "rChEA3_query").}

\item{verbose}{Logical; if TRUE, print a grouped summary of available
result collections (default: TRUE).}
}
\value{
A named list of data frames. Each element corresponds to a ChEA3
collection and contains an enrichment table with transcription factors and
their statistics. The expected names are:
c("Integrated--meanRank", "Integrated--topRank",
"GTEx--Coexpression", "ARCHS4--Coexpression",
"ENCODE--ChIP-seq", "ReMap--ChIP-seq",
"Literature--ChIP-seq", "Enrichr--Queries").
}
\description{
#' Sends a gene list to the ChEA3 web service to identify enriched
transcription factors using multiple evidence sources.
The gene list should consist of HGNC-approved gene symbols.
}
\examples{
\donttest{
    results <- queryChEA3(c("SMAD9","FOXO1","MYC","STAT1","STAT3","SMAD3"))
    names(results)
    head(results[["Integrated--meanRank"]])
}
}
