% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solving_equations.R
\name{solving_equations}
\alias{solving_equations}
\title{solving_equations helper function}
\usage{
solving_equations(
  datatable,
  regmethod,
  type,
  rv,
  mode = NULL,
  logfilename,
  minmax
)
}
\arguments{
\item{datatable}{A data.table object that contains either the experimental
data or the calibration data.}

\item{regmethod}{A data.table object, with 2 columns, containing the names
of the samples to correct (columns 1) and a binary variable
\emph{better_model} that indicates, if the data should be corrected with
the hyperbolic regression parameters (better_model = 0) or with the
cubic regression parameters (better_model = 1).}

\item{type}{A single integer. Type of data to be corrected: either \code{1L} (one
locus in many samples, e.g. pyrosequencing data) or \code{2L} (many loci in one
sample, e.g. next-generation sequencing data or microarray data).}

\item{rv}{A list object. A list that contains additional objects needed
for the algorithms.}

\item{mode}{A character string. Default: NULL. Used to indicate "corrected"
calibration data.}

\item{logfilename}{A character string. Path to a file to save the log
messages (default = paste0(tempdir(), "/log.txt")).}

\item{minmax}{A logical, indicating which equations are used for
BiasCorrection (default: FALSE). If TRUE, equations are used that include
the respective minima and maxima of the provided data.}
}
\value{
This function solves the equations of the hyperbolic and the
cubic regression and returns the respectively interpolated values of the
provided \code{datatable}.
}
\description{
Internal function to solve the hyperbolic and cubic regression.
}
\examples{
\donttest{
# define list object to save all data
rv <- list()
rv$minmax <- TRUE
rv$selection_method <- "RelError"
rv$sample_locus_name <- "Test"
rv$seed <- 1234

# define logfilename
logfilename <- paste0(tempdir(), "/log.txt")

# import experimental file
exp_type_1 <- rBiasCorrection::example.data_experimental
rv$fileimport_experimental <- exp_type_1$dat

# import calibration file
cal_type_1 <- rBiasCorrection::example.data_calibration
rv$fileimport_calibration <- cal_type_1$dat
rv$vec_cal <- cal_type_1$vec_cal


# perform regression
regression_results <- regression_utility(
  rv$fileimport_calibration,
  "Testlocus",
  locus_id = NULL,
  rv = rv,
  mode = NULL,
  logfilename,
  minmax = rv$minmax,
  seed = rv$seed
)

# extract regression results
rv$result_list <- regression_results$result_list

# get regression statistics
rv$reg_stats <- statistics_list(
  rv$result_list,
  minmax = TRUE
)

# select the better model based on the sum of squared errrors ("SSE")
rv$choices_list <- better_model(
  statstable_pre = rv$reg_stats,
  selection_method = "SSE"
)

# correct calibration data (to show corrected calibration curves)
solved_eq_h <- solving_equations(datatable = rv$fileimport_calibration,
                                 regmethod = rv$choices_list,
                                 type = 1,
                                 rv = rv,
                                 mode = "corrected",
                                 logfilename = logfilename,
                                 minmax = rv$minmax)
rv$fileimport_cal_corrected_h <- solved_eq_h$results
colnames(rv$fileimport_cal_corrected_h) <- colnames(
  rv$fileimport_calibration
)
}

}
