% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{facDesign}
\alias{facDesign}
\title{facDesign}
\usage{
facDesign(
  k = 3,
  p = 0,
  replicates = 1,
  blocks = 1,
  centerCube = 0,
  random.seed = 1234
)
}
\arguments{
\item{k}{Numeric value giving the number of factors. By default k is set to `3`.}

\item{p}{Numeric integer between `0` and `7`. p is giving the number of additional factors in the response surface design by aliasing effects.
For further information see fracDesign and fracChoose.
By default p is set to `0`.}

\item{replicates}{Numeric value giving the number of \code{replicates} per factor combination. By default replicates is set to `1`.}

\item{blocks}{Numeric value giving the number of blocks. By default blocks is set to `1`. Blocking is only performed for k greater 2.}

\item{centerCube}{Numeric value giving the number of centerpoints within the 2^k design. By default \code{centerCube} is set to `0`.}

\item{random.seed}{Numeric value for setting the random seed for reproducibility.}
}
\value{
The function \code{facDesign} returns an object of class \code{\link{facDesign.c}}.
}
\description{
Generates a 2^k full factorial design.
}
\examples{
# Example 1
vp.full <- facDesign(k = 3)
vp.full$.response(rnorm(2^3))
vp.full$summary()

# Example 2
vp.rep <- facDesign(k = 2, replicates = 3, centerCube = 4)
vp.rep$names(c("Name 1", "Name 2"))
vp.rep$unit(c("min", "F"))
vp.rep$lows(c(20, 40, 60))
vp.rep$highs(c(40, 60, 80))
vp.rep$summary()

# Example 3
dfac <- facDesign(k = 3, centerCube = 4)
dfac$names(c('Factor 1', 'Factor 2', 'Factor 3'))
dfac$names()
dfac$lows(c(80, 120, 1))
dfac$lows()
dfac$highs(c(120, 140, 2))
dfac$highs()
dfac$summary()
}
\seealso{
\code{\link{fracDesign}}, \code{\link{fracChoose}}, \code{\link{rsmDesign}}, \code{\link{pbDesign}}, \code{\link{taguchiDesign}}
}
