% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oruns_test.R
\name{oruns_test}
\alias{oruns_test}
\title{Runs Test}
\usage{
oruns_test(x)
}
\arguments{
\item{x}{A numeric vector representing the input data}
}
\value{
an \code{r4pde.oruns} object.

An \code{r4pde.oruns} object is a \code{list} containing:
\itemize{
\item U, number of runs,
\item EU, expected number of runs,
\item sU, standard deviation of the expected number of runs
\item Z, Z-score of the observed number of runs,
\item pvalue, the p-value of the Z-score, and
\item result, the test result of either "aggregation or clustering" or "randomness"
}
}
\description{
Perform a runs test on the input data to test for clustering or randomness.
}
\examples{
oruns_test(c(1, 0, 1, 1, 0, 1, 0, 0, 1, 1))

}
\seealso{
Other Spatial analysis: 
\code{\link{AFSD}()},
\code{\link{BPL}()},
\code{\link{count_subareas}()},
\code{\link{count_subareas_random}()},
\code{\link{fit_gradients}()},
\code{\link{join_count}()},
\code{\link{oruns_test_boustrophedon}()},
\code{\link{oruns_test_byrowcol}()},
\code{\link{plot_AFSD}()}
}
\concept{Spatial analysis}
