% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{m_add_label}
\alias{m_add_label}
\title{Add label to viewer}
\usage{
m_add_label(id, text, style = m_style_label(), sel = m_sel(), noshow = TRUE)
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{text}{Label text}

\item{style}{Label style specification}

\item{sel}{Set position of label to center of this selection}

\item{noshow}{if \code{TRUE}, do not immediately display label - when adding
multiple labels this is more efficient}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
Add label to viewer
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_model(data = pdb_6zsl, format = "pdb") \%>\%
  m_add_label(
    text = "Label",
    sel = m_vector3(-6.89, 0.75, 0.35),
    style = m_style_label(
      backgroundColor = "#666666",
      backgroundOpacity = 0.9
    )
  ) \%>\%
  m_zoom_to()
}
