% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_results.R
\name{queryToExpr}
\alias{queryToExpr}
\title{Parse query rules to R filtering expression}
\usage{
queryToExpr(query, keep_na = FALSE, .queryBuilderConfig = queryBuilderConfig)
}
\arguments{
\item{query}{Query definition (see \link{queryRule} and \link{queryGroup}).}

\item{keep_na}{Should query keep or exclude missing values?}

\item{.queryBuilderConfig}{R6 class object storing query configuration. See \link{queryBuilderConfigClass}.}
}
\value{
Object of class 'call'. A filtering expression that can be passed to 'dplyr'-based filtering methods.
}
\description{
The function takes a list of condition rules provided by the widget (\code{input[[<widget-name>]]}) and
returns valid R expression that can be used for example in \link[dplyr]{filter} function.
}
\examples{

query <- queryGroup(
  condition = "AND",
  queryGroup(
    queryRule(
      field = "Species",
      operator = "equal",
      value = "setosa"
    ),
    queryRule(
      field = "Petal.Length",
      operator = "less",
      value = 1.2
    )
  )
)
queryToExpr(query)
dplyr::filter(iris, !!queryToExpr(query))

}
