% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{projection}
\alias{projection}
\alias{projection,Quadtree-method}
\alias{projection<-}
\alias{projection<-,Quadtree,ANY-method}
\alias{projection<-,Quadtree-method}
\title{Retrieve the projection of a \code{Quadtree}}
\usage{
\S4method{projection}{Quadtree}(x)

\S4method{projection}{Quadtree}(x) <- value
}
\arguments{
\item{x}{a \code{\link{Quadtree}}}

\item{value}{character; the projection to assign to the
\code{\link{Quadtree}}}
}
\value{
a string
}
\description{
Retrieves the projection of a \code{\link{Quadtree}}.
}
\examples{
library(quadtree)
habitat <- terra::rast(system.file("extdata", "habitat.tif", package="quadtree"))

qt <- quadtree(habitat, .1)
quadtree::projection(qt) <- "+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs"
quadtree::projection(qt)
}
