% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quran.R
\docType{data}
\name{quran_ar_min}
\alias{quran_ar_min}
\title{The text of the Qur'an (Arabic, no vowels)}
\format{A data frame with 6236 rows and 18 columns:
\describe{
  \item{\code{surah_id}}{Unique id number for the surah}
  \item{\code{ayah_id}}{Unique id number for the ayah}
  \item{\code{surah_title_ar}}{Name of the surah (Arabic)}
  \item{\code{surah_title_en}}{Name of the surah (English; transliterated)}
  \item{\code{surah_title_en_trans}}{Name of the surah (English; translated)}
  \item{\code{revelation_type}}{Type of the surah (Meccan or Medinan)}
  \item{\code{text}}{Ayah text}
  \item{\code{surah}}{Surah}
  \item{\code{ayah}}{Ayah}
  \item{\code{ayah_title}}{Combined surah and ayah (e.g. 2:242)}
  \item{\code{juz}}{Juz'}
  \item{\code{manzil}}{Manzil}
  \item{\code{page}}{Page number}
  \item{\code{hizb_quarter}}{Maqra}
  \item{\code{sajda}}{Binary indicator for presence of a sajdah}
  \item{\code{sajda_id}}{Unique id number for the sajdah}
  \item{\code{sajda_recommended}}{Binary indicator for whether a sajdah is recommended}
  \item{\code{sajda_obligatory}}{Binary indicator for whether a sajdah is obligatory}
}}
\source{
Tanzil (\url{http://tanzil.net/docs/download}) and Al Quran Cloud (\url{https://alquran.cloud/})
}
\usage{
quran_ar_min
}
\description{
A dataset containing the Arabic text of the Qur'an, without vowels.
}
\details{
Because Surahs 89 and 113 are both translated as "The Dawn," Surah 113 has
been retitled "The Daybreak"
}
\examples{
# See first few rows
head(quran_ar_min)

# How many ayahs are in each surah?
library(dplyr)

quran_ar_min \%>\%
  group_by(surah_title_ar) \%>\%
  summarize(total_ayaat = n())
}
\keyword{datasets}
