% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatt.R
\name{spatt}
\alias{spatt}
\title{spatt}
\usage{
spatt(
  formla,
  xformla = NULL,
  t,
  tmin1,
  tname,
  data,
  w = NULL,
  panel = FALSE,
  idname = NULL,
  iters = 100,
  alp = 0.05,
  method = "logit",
  plot = FALSE,
  se = TRUE,
  retEachIter = FALSE,
  seedvec = NULL,
  pl = FALSE,
  cores = 2
)
}
\arguments{
\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary)}

\item{xformla}{A optional one sided formula for additional covariates that
will be adjusted for.  E.g ~ age + education.  Additional covariates can
also be passed by name using the x paramater.}

\item{t}{The 3rd time period in the sample (this is the name of the column)}

\item{tmin1}{The 2nd time period in the sample (this is the name of the
column)}

\item{tname}{The name of the column containing the time periods}

\item{data}{The name of the data.frame that contains the data}

\item{w}{an additional vector of sampling weights}

\item{panel}{Boolean indicating whether the data is panel or repeated cross
sections}

\item{idname}{The individual (cross-sectional unit) id name}

\item{iters}{The number of iterations to compute bootstrap standard errors.
This is only used if se=TRUE}

\item{alp}{The significance level used for constructing bootstrap
confidence intervals}

\item{method}{The method for estimating the propensity score when covariates
are included}

\item{plot}{Boolean whether or not the estimated QTET should be plotted}

\item{se}{Boolean whether or not to compute standard errors}

\item{retEachIter}{Boolean whether or not to return list of results
from each iteration of the bootstrap procedure}

\item{seedvec}{Optional value to set random seed; can possibly be used
in conjunction with bootstrapping standard errors.}

\item{pl}{boolean for whether or not to compute bootstrap error in parallel.
Note that computing standard errors in parallel is a new feature and may
not work at all on Windows.}

\item{cores}{the number of cores to use if bootstrap standard errors are
computed in parallel}
}
\value{
\code{QTE} object
}
\description{
\code{spatt} computes the Average Treatment Effect on the
Treated (ATT) using the method of Abadie (2005)
}
\examples{
##load the data
data(lalonde)

## Run the panel.qtet method on the experimental data with no covariates
att1 <- spatt(re ~ treat, t=1978, tmin1=1975, tname="year",
 x=NULL, data=lalonde.psid.panel, idname="id", se=FALSE)
summary(att1)

## Run the panel.qtet method on the observational data with no covariates


}
\references{
Abadie (2005)
}
