% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qr_location.R
\name{qr_location}
\alias{qr_location}
\title{Create a QR code for a location}
\usage{
qr_location(latitude, longitude, ecl = c("L", "M", "Q", "H"))
}
\arguments{
\item{latitude}{the latitude of the location.}

\item{longitude}{the longitude of the location.}

\item{ecl}{the required error correction level.
Available options are \code{"L"} (7\%), \code{"M"} (15\%), \code{"Q"} (25\%) and \code{"H"} (30\%).
Defaults to \code{"L"}.}
}
\description{
Create a QR code for a location
}
\examples{
qr_location(50.8449861, 4.3499932) |>
  plot()
}
\seealso{
Other qr: 
\code{\link{coordinates}()},
\code{\link{generate_svg}()},
\code{\link{plot.qr_code}()},
\code{\link{print.qr_code}()},
\code{\link{qr_code}()},
\code{\link{qr_event}()},
\code{\link{qr_sepa}()},
\code{\link{qr_wifi}()}
}
\concept{qr}
