% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cc_err.R
\name{add_cc_err}
\alias{add_cc_err}
\title{Add error to the calibration coefficients}
\usage{
add_cc_err(cc_true, err_bound)
}
\arguments{
\item{cc_true}{A vector of calibration coefficients, intended to be the object
\code{cc} returned by the function \code{\link{prep_fa}}.}

\item{err_bound}{A proportion strictly greater than 0 and less than 1 used to
control the lower and upper bounds of calibration coefficient error.}
}
\value{
A list containing the following elements: \describe{
  \item{cc}{A numeric vector of calibration coefficients with error
    incorporated.}
  \item{err}{The mean relative absolute error in the calibration
    coefficients.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
}
}
\description{
Bromaghin et al (2016) studied the performance of QFASA estimators when
predator diets were estimated using calibration coefficients that
incorporated a degree of error. \code{add_cc_err} implements their method of
adding error to a set of calibration coefficients.
}
\section{Details}{

One of the major assumptions of QFASA is that the calibration coefficients
are known perfectly. Bromaghin et al. (2016) investigated the robustness of
diet estimators to violations of this assumption. The function
\code{add_cc_err} uses the methods of Bromaghin et al. (2016) to add error
to a set of calibration coefficients.

The argument err_bound is used to compute box constraints for the calibration
coefficients: lower bound equals \code{(1 - err_bound)*cc_true} and upper
bound equals \code{(1 + err_bound)*cc_true}. A uniformly distributed random
number is generated between the bounds for each calibration coefficient and
the vector of coefficients is scaled so that their sum equals the sum of the
true calibration coefficients. Because only the relative magnitudes of the
calibration coefficients are important in diet estimation, scaling the
coefficients to have a common sum ensures comparability between multiple
sets of coefficients.

The mean relative absolute difference between the true and error-added
calibration coefficients is computed as a measure of error for the entire
vector.
}

\section{References}{

Bromaghin, J.F., S.M. Budge, G.W. Thiemann, and K.D. Rode. 2016. Assessing
  the robustness of quantitative fatty acid signature analysis to assumption
  violations. \emph{Methods in Ecology and Evolution} 7:51-59.
}

\examples{
add_cc_err(cc_true = c(0.75, 1.00, 1.50, 1.15),
           err_bound = 0.25)

}
