% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateHistory.R
\name{CreateHistory}
\alias{CreateHistory}
\title{Create a Subject History Table}
\usage{
CreateHistory(
  rawData_ls,
  personsTable = "everybody",
  firstDay_int = NULL,
  lastDay_int = NULL
)
}
\arguments{
\item{rawData_ls}{a list of tibbles returned by \code{\link{loadRawData}}}

\item{personsTable}{What is the name of the data table that contains all the
subject IDs? Defaults to \code{"everybody"}. If no such table exists, then
set this value to \code{"none"} and the unique subject IDs will be drawn
from all tables in \code{rawData_ls}}

\item{firstDay_int}{(OPTIONAL) What should be the first "day" counter for all
subjects? This may be beneficial to set if you wish to have the History
ignore all days before a certain point.}

\item{lastDay_int}{(OPTIONAL) What should be the last "day" counter for all
subjects?}
}
\value{
A tibble with columns \code{who} and \code{when}. Each subject will
have one row for each day in the study range.
}
\description{
Create a Subject History Table
}
\details{
We may want to perform SQL-like operations on a set of tables. This
data table will form the "backbone" for future join operations. It creates
one record per person for each day in the study. The default behavior is
to set the date range to the smallest observed value for "when" across all
data tables to the largest observed value for "when" across all tables,
inclusive. Necessarily, this is \emph{very} sensitive to outliers or
coding errors (for instance, if one subject has a "first day" 200 days
before Study Day 0, then this History table will include days -200 to -1
for ALL subjects, regardless of any recorded contact in this period).

If this behavior is not desirable, you must specify a study range. For
example, you may have a short recruitment period followed by a 6-month
clinical trial. In this instance, you may want to ignore any data more
than 30 days prior to Study Day 0 for each subject or more than a few
weeks after the end of the trial. Thus, you would set
\code{firstDay_int = -30L} and \code{lastDay_int = 6 * 30 + 14}.
}
\examples{
   data_ls <- loadRawData(c("tlfb", "all_drugs", "everybody"))
   CreateHistory(rawData_ls = data_ls, firstDay_int = -30)
}
